<?php
/* --------------------------------------------------------------
   Language.php 2020-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Model;

use Gambio\Core\Language\LanguageCode;
use Gambio\Core\Language\LanguageId;

/**
 * Class Language
 *
 * @package Gambio\Core\Language\Model
 */
class Language implements \Gambio\Core\Language\Language
{
    /**
     * @var LanguageId
     */
    private $id;
    
    /**
     * @var LanguageCode
     */
    private $code;
    
    /**
     * @var string
     */
    private $name;
    
    /**
     * @var string
     */
    private $charset;
    
    /**
     * @var string
     */
    private $directory;
    
    
    /**
     * Language constructor.
     *
     * @param LanguageId   $id
     * @param LanguageCode $code
     * @param string       $name
     * @param string       $charset
     * @param string       $directory
     */
    private function __construct(
        LanguageId $id,
        LanguageCode $code,
        string $name,
        string $charset,
        string $directory
    ) {
        $this->id        = $id;
        $this->code      = $code;
        $this->name      = $name;
        $this->charset   = $charset;
        $this->directory = $directory;
    }
    
    
    /**
     * @param LanguageId   $id
     * @param LanguageCode $code
     * @param string       $name
     * @param string       $charset
     * @param string       $directory
     *
     * @return Language
     */
    public static function create(
        LanguageId $id,
        LanguageCode $code,
        string $name,
        string $charset,
        string $directory
    ): Language {
        return new self($id, $code, $name, $charset, $directory);
    }
    
    
    /**
     * @inheritDoc
     */
    public function id(): int
    {
        return $this->id->value();
    }
    
    
    /**
     * @inheritDoc
     */
    public function code(): string
    {
        return $this->code->value();
    }
    
    
    /**
     * @inheritDoc
     */
    public function name(): string
    {
        return $this->name;
    }
    
    
    /**
     * @inheritDoc
     */
    public function charset(): string
    {
        return $this->charset;
    }
    
    
    /**
     * @inheritDoc
     */
    public function directory(): string
    {
        return $this->directory;
    }
}